<?php
//VERSION 0


function AddPaiementBD($idEcole,$idFormule,$idProduit,$idLocation,$idFactureGroupee,$idStaff,$type,$montant,$comment,$date){
	//On fait un lock table ici pour etre sur qu'il n'y ai pas d'ajout de paiement entre temps
	//[dernière valeur de hash lue - enregistrement] 
	LockTable("paiement");
	$veryLast=GetVeryLastHash("paiement");
	$thisToBeHashed=$idEcole.$idFormule.$idProduit.$idLocation.$idFactureGroupee.$type.$montant.$date.$veryLast;
	$hash=HashThis($thisToBeHashed);
	$sql_ecrit = "INSERT into paiement (link_id_ecole, link_id_formule, link_id_produit, link_id_location, link_id_facture_groupee, link_id_staff, type, montant, date_paiement, commentaire, hash)";
	$sql_ecrit .= " values (".$idEcole.",".$idFormule.",".$idProduit.",".$idLocation.",".$idFactureGroupee.",".$idStaff.",'".$type."','".$montant."','".$date."','".addslashes($comment)."','".$hash."')"; 
	$query = mysqli_query($GLOBALS['db'],$sql_ecrit);
	@mysqli_free_result($query);
	UnlockTable();
}
function LockTable($table){
	$sql_ecrit= "Lock Table ".$table." Write;";
	$query = mysqli_query($GLOBALS['db'],$sql_ecrit);
	@mysqli_free_result($query);
}
function UnlockTable(){
	$sql_ecrit= "Unlock Tables";
	$query = mysqli_query($GLOBALS['db'],$sql_ecrit);
	@mysqli_free_result($query);
}
function GetVeryLastHash($table){
//	$req_sql = "SELECT hash FROM ".$table." WHERE id_".$table."=( SELECT max(id_".$table.") as id FROM ".$table.")";
//Ca aurait été mieux hein? mais avec le lock, ca ne marche pas...
	$req_sql = "SELECT max(id_".$table.") as id FROM ".$table;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	if($query==false){
		$id=-1;
	}
	else{
		$row = mysqli_fetch_array($query);
		$id=$row['id'];
	}
	@mysqli_free_result($query);
	$ret=-1;
	if($id!=-1){
		$req_sql = "SELECT hash FROM ".$table." WHERE id_".$table."=".$id;
		$query = mysqli_query($GLOBALS['db'],$req_sql);
		if($query==false){
			$ret=-1;
		}
		else{
			$row = mysqli_fetch_array($query);
			$ret=$row['hash'];
		}
		@mysqli_free_result($query);
	}
	return $ret;
}
function GetPaimentOldWayBD($idEcole,$idFormule){
	$req_sql = "SELECT paye_cb,date_paye_cb,paye_cheque_vac,date_paye_cheque_vac, paye_cheque,date_paye_cheque, paye_cash,date_paye_cash,paye_virement,date_paye_virement, commentaire FROM formule 
		WHERE link_id_ecole=".$idEcole." and id_formule=".$idFormule;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
//echo "</br>".$req_sql;
	if($query==false){
		$ret=-1;
	}
	else{
		$row = mysqli_fetch_array($query);
		$ret['paye_cb']=$row['paye_cb'];
		$ret['date_paye_cb']=$row['date_paye_cb'];
		$ret['paye_cheque_vac']=$row['paye_cheque_vac'];
		$ret['date_paye_cheque_vac']=$row['date_paye_cheque_vac'];
		$ret['paye_cheque']=$row['paye_cheque'];
		$ret['date_paye_cheque']=$row['date_paye_cheque'];
		$ret['paye_cash']=$row['paye_cash'];
		$ret['date_paye_cash']=$row['date_paye_cash'];
		$ret['paye_virement']=$row['paye_virement'];
		$ret['date_paye_virement']=$row['date_paye_virement'];
		$ret['paye_amex']=0;
		$ret['date_paye_amex']="0000-00-00 00:00:00";
		$ret['paye_paypal']=0;
		$ret['date_paye_paypal']="0000-00-00 00:00:00";
		$ret['paye_bon_cadeau']=0;
		$ret['date_paye_bon_cadeau']="0000-00-00 00:00:00";
		$ret['commentaire']=$row['commentaire'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetPaimentNewWayBD($idEcole,$idFormule){
	$req_sql = "SELECT id_paiement, type, montant, date_paiement, commentaire FROM paiement 
		WHERE link_id_ecole=".$idEcole." and link_id_formule=".$idFormule." Order by id_paiement";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$info=Array();
	$cpt=0;
	$ret=Array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$ret[$cpt]['idPaiement']=$row['id_paiement'];
		$ret[$cpt]['montant']=$row['montant'];
		$ret[$cpt]['date']=RenverseDateDifferentEncore($row['date_paiement']);
		$ret[$cpt]['type']=$row['type'];
		$ret[$cpt]['commentaire']=$row['commentaire'];
		$cpt++;
	}
	@mysqli_free_result($query);
	return $ret;
}
function AddDTFBD($idEcole,$typeArticle,$idArticle,$numero,$version,$date,$lienVersAncienDTFFactureGroupee,$param){
	$remiseFactureGroupeeMontant=isset($param['remiseFactureGroupeeMontant'])?$param['remiseFactureGroupeeMontant']:"";
	$remiseFactureGroupeeDisplay=isset($param['remiseFactureGroupeeDisplay'])?$param['remiseFactureGroupeeDisplay']:"";

	//Adding the hash
	LockTable("devis_ticket_facture");
	$veryLast=GetVeryLastHash("devis_ticket_facture");
	$idsForHash['formule']=-1;
	$idsForHash['produit']=-1;
	$idsForHash['location']=-1;
	$idsForHash['facture_groupee']=-1;
	$idsForHash[$typeArticle]=$idArticle;
	$thisToBeHashed=$idEcole.$idsForHash['formule'].$idsForHash['produit'].$idsForHash['location'].$idsForHash['facture_groupee'].$numero."_".$version.$date.$param['totalHT'].$param['totalTVA'].$param['totalTTC'].$param['totalMontantDeLaRemise'].addslashes($param['articleDescriptif']).$param['articleTauxTVA'].$param['ArticleMontantHT'].$param['ArticleMontantTVA'].$param['ArticleMontantTTC'].$param['articleRemiseMontant'].$param['reglementType'].$param['reglementMontant'].$param['restantDu'].$veryLast;
//Then add this to the insert.
	$hash=HashThis($thisToBeHashed);
	$sql_ecrit= "INSERT into devis_ticket_facture  (link_id_ecole,link_id_".$typeArticle.",  numero, version, date_creation, from_link_id_dtf_facture_groupee, total_ht, total_tva, total_ttc, total_de_la_remise_montant, remise_facture_groupee_montant, remise_facture_groupee_display, article_descriptif, article_descriptif_extra, article_taux_tva, article_montant_ht, article_montant_tva, article_montant_ttc, article_remise_montant, article_remise_display,reglement_type, reglement_montant, restant_du,moniteurs_intervenants,hash)";
	$sql_ecrit .= " values (".$idEcole.",".$idArticle.",'".$numero."',".$version.",'".$date."',".$lienVersAncienDTFFactureGroupee.", '".$param['totalHT']."', '".$param['totalTVA']."', '".$param['totalTTC']."', '".$param['totalMontantDeLaRemise']."', '".$remiseFactureGroupeeMontant."', '".addslashes($remiseFactureGroupeeDisplay)."', '".addslashes($param['articleDescriptif'])."', '".addslashes($param['articleDescriptifExtra'])."', '".$param['articleTauxTVA']."', '".$param['ArticleMontantHT']."', '".$param['ArticleMontantTVA']."', '".$param['ArticleMontantTTC']."', '".$param['articleRemiseMontant']."', '".$param['articleRemiseDisplay']."', '".$param['reglementType']."', '".$param['reglementMontant']."', '".$param['restantDu']."', '".addslashes($param['listingMoniteurExtra'])."','".$hash."')"; 
	$query = mysqli_query($GLOBALS['db'],$sql_ecrit);
	$req_sql = "SELECT id_devis_ticket_facture FROM devis_ticket_facture 
		WHERE link_id_ecole=".$idEcole." and link_id_".$typeArticle."=".$idArticle." order by id_devis_ticket_facture desc limit 1";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	if($query==false){
		$id=-1;
	}
	else{
		$row = mysqli_fetch_array($query);
		$id=$row['id_devis_ticket_facture'];
	}
	@mysqli_free_result($query);
	UnlockTable();
	return $id;
}
function GetDTFWithMaxVersionNbBD($idEcole,$typeArticle,$idArticle,$pref){
	$sousRequete="SELECT max(version) FROM devis_ticket_facture 
		WHERE link_id_ecole=".$idEcole." and link_id_".$typeArticle."=".$idArticle." and numero like '".$pref."%'";

	$req_sql = "SELECT id_devis_ticket_facture, numero, version, invalide_date, date_creation FROM devis_ticket_facture 
		WHERE link_id_ecole=".$idEcole." and link_id_".$typeArticle."=".$idArticle." and numero like '".$pref."%' and version=(".$sousRequete.")";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$ret['idDTF']="";
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret['idDTF']=$row['id_devis_ticket_facture'];
		$ret['numero']=$row['numero'];
		$ret['version']=$row['version'];
		$ret['invalideDate']=$row['invalide_date'];
		$ret['dateCreation']=$row['date_creation'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function InvalideDTFBD($idEcole,$idDTFaInvalider,$date,$motif,$nouvelId){
	$sql_ecrit="Update devis_ticket_facture set";
	$sql_ecrit.=" invalide_date='".$date."'";
	$sql_ecrit.=", invalide_motif='".addslashes($motif)."'";
	$sql_ecrit.=", invalide_link_new_id_devis_ticket_facture=".$nouvelId;
	$sql_ecrit.=" WHERE link_id_ecole=".$idEcole." and id_devis_ticket_facture=".$idDTFaInvalider." and invalide_date=\"\";";
	//test sur invalide_date pour ne pas ecraser de contenu,notamment lorsqu'on sort un article d'une facture groupée
	//cet article là n'a plus d'enr en cours
	//L'enr en cours est positionné sur la facture groupée.
	$query = mysqli_query($GLOBALS['db'],$sql_ecrit);
	@mysqli_free_result($query);
}
function GetCurrentDTFBD($idEcole,$typeArticle,$idArticle){
	$req_sql = "SELECT id_devis_ticket_facture, numero, version FROM devis_ticket_facture 
		WHERE link_id_ecole=".$idEcole." and link_id_".$typeArticle."=".$idArticle." and invalide_date=''";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$ret['idDTF']="";
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret['idDTF']=$row['id_devis_ticket_facture'];
		$ret['numero']=$row['numero'];
		$ret['version']=$row['version'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetPaimentLocationBD($idEcole,$idLocation){
	$req_sql = "SELECT id_paiement, type, montant, date_paiement, commentaire FROM paiement 
		WHERE link_id_ecole=".$idEcole." and link_id_location=".$idLocation." Order by id_paiement";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$info=Array();
	$cpt=0;
	$ret=Array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$ret[$cpt]['idPaiement']=$row['id_paiement'];
		$ret[$cpt]['montant']=$row['montant'];
		$ret[$cpt]['date']=RenverseDateDifferentEncore($row['date_paiement']);
		$ret[$cpt]['type']=$row['type'];
		$ret[$cpt]['commentaire']=$row['commentaire'];
		$cpt++;
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetPaimentProduitBD($idEcole,$idProduit){
	$req_sql = "SELECT id_paiement, type, montant, date_paiement, commentaire FROM paiement 
		WHERE link_id_ecole=".$idEcole." and link_id_produit=".$idProduit." Order by id_paiement";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$info=Array();
	$cpt=0;
	$ret=Array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$ret[$cpt]['idPaiement']=$row['id_paiement'];
		$ret[$cpt]['montant']=$row['montant'];
		$ret[$cpt]['date']=RenverseDateDifferentEncore($row['date_paiement']);
		$ret[$cpt]['type']=$row['type'];
		$ret[$cpt]['commentaire']=$row['commentaire'];
		$cpt++;
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetRemiseFactureGroupeeBD($idEcole,$idFactureGroupee){
	$req_sql = "SELECT discount FROM facture_groupee 
			WHERE link_id_ecole=".$idEcole." and id_facture_groupee=".$idFactureGroupee;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$cpt=0;
	$ret=0;
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret=$row['discount'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetPaimentNewWayFactureGroupeeBD($idEcole,$idFactureGroupee){
	$req_sql = "SELECT id_paiement, type, montant, date_paiement, commentaire FROM paiement 
		WHERE link_id_ecole=".$idEcole." and link_id_facture_groupee=".$idFactureGroupee." Order by id_paiement";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$info=Array();
	$cpt=0;
	$ret=Array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$ret[$cpt]['idPaiement']=$row['id_paiement'];
		$ret[$cpt]['montant']=$row['montant'];
		$ret[$cpt]['date']=RenverseDateDifferentEncore($row['date_paiement']);
		$ret[$cpt]['type']=$row['type'];
		$ret[$cpt]['commentaire']=$row['commentaire'];
		$cpt++;
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetDTFInfoBD($idEcole,$idDTF){
	$req_sql = "SELECT * FROM devis_ticket_facture 
		WHERE link_id_ecole=".$idEcole." and id_devis_ticket_facture=".$idDTF;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$ret=Array();
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret['idFormule']=$row['link_id_formule'];
		$ret['idLocation']=$row['link_id_location'];
		$ret['idProduit']=$row['link_id_produit'];
		$ret['idFactureGroupee']=$row['link_id_facture_groupee'];
		$ret['numero']=$row['numero'];
		$ret['version']=$row['version'];
		$ret['dateCreation']=$row['date_creation'];
		$ret['totalHT']=$row['total_ht'];
		$ret['totalTVA']=$row['total_tva'];
		$ret['totalTTC']=$row['total_ttc'];
		$ret['totalMontantDeLaRemise']=$row['total_de_la_remise_montant'];
		$ret['RemiseFactureGroupeeMontant']=$row['remise_facture_groupee_montant'];
		$ret['RemiseFactureGroupeeDisplay']=$row['remise_facture_groupee_display'];
		$ret['articleDescriptif']=GetValuesFromComaList($row['article_descriptif'],";");
		$ret['articleDescriptifExtra']=GetValuesFromComaList($row['article_descriptif_extra'],";");
		$ret['listingMoniteurExtra']=GetValuesFromComaList($row['moniteurs_intervenants'],";");
		$ret['articleTauxTVA']=GetValuesFromComaList($row['article_taux_tva'],";");
		$ret['articleMontantHT']=GetValuesFromComaList($row['article_montant_ht'],";");
		$ret['articleMontantTVA']=GetValuesFromComaList($row['article_montant_tva'],";");
		$ret['articleMontantTTC']=GetValuesFromComaList($row['article_montant_ttc'],";");
		$ret['articleRemiseMontant']=GetValuesFromComaList($row['article_remise_montant'],";");
		$ret['articleRemiseDisplay']=GetValuesFromComaList($row['article_remise_display'],";");
		$ret['reglementType']=GetValuesFromComaList($row['reglement_type'],";");
		$ret['reglementMontant']=GetValuesFromComaList($row['reglement_montant'],";");
		$ret['restantDu']=$row['restant_du'];
		$ret['hash']=$row['hash'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetEcoleInfoBD($idEcole){
	$req_sql = "SELECT * from ecole";
	$req_sql.=" WHERE id_ecole=".$idEcole;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$ret=Array();
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret['idEcole']=$row['id_ecole'];
		$ret['nom']=$row['nom'];
		$ret['adresse']=$row['adresse'];
		$ret['adresseVille']=$row['adresse_ville'];
		$ret['tel1']=$row['tel1'];
		$ret['tel2']=$row['tel2'];
		$ret['fax']=$row['fax'];
		$ret['email']=$row['email'];
		$ret['tauxTvaPrincipal']=$row['taux_tva_principal'];
		$ret['banque']=$row['banque'];
		$ret['titulaireCpt']=$row['titulaire_cpt'];
		$ret['codeBanque']=$row['code_banque'];
		$ret['codeGuichet']=$row['code_guichet'];
		$ret['numCpt']=$row['num_cpt'];
		$ret['cle']=$row['cle'];
		$ret['formueJuridique']=$row['forme_juridique'];
		$ret['capitalSocial']=$row['capital_social'];
		$ret['denominationSociale']=$row['denomination_sociale'];
		$ret['adresseSiegeSocial1']=$row['adresse_siege_social_1'];
		$ret['adresseSiegeSocial2']=$row['adresse_siege_social_2'];
		$ret['adresseSiegeSocial3']=$row['adresse_siege_social_3'];
		$ret['immatriculationRCS']=$row['immatriculation_rcs'];
		$ret['numSiren']=$row['num_siren'];
		$ret['numTva']=$row['num_tva'];
		$ret['numSiret']=$row['num_siret'];
		$ret['factureEnteteExtra1']=$row['facture_entete_extra_1'];
		$ret['factureEnteteExtra2']=$row['facture_entete_extra_2'];
		$ret['factureEnteteExtra3']=$row['facture_entete_extra_3'];
		$ret['factureEnteteExtra4']=$row['facture_entete_extra_4'];
		$ret['facturePiedPageExtra1']=$row['facture_pied_page_extra_1'];
		$ret['facturePiedPageExtra2']=$row['facture_pied_page_extra_2'];
		$ret['facturePiedPageExtra3']=$row['facture_pied_page_extra_3'];
		$ret['facturePiedPageExtra4']=$row['facture_pied_page_extra_4'];
		$ret['website']=$row['website'];
		$ret['mentionSpeciale1']=$row['mention_speciale_pdf1'];
		$ret['mentionSpeciale2']=$row['mention_speciale_pdf2'];
		$ret['mentionSpeciale3']=$row['mention_speciale_pdf3'];
		$ret['mentionSpeciale4']=$row['mention_speciale_pdf4'];
		$ret['doubleEnvoiEmail']=$row['double_envoi_email'];
		$ret['schoolMonitoring']=$row['school_monitoring'];
		$ret['ecoleActive']=$row['ecole_active'];
		$ret['emailPaperasse']=GetValuesFromComaList($row['email_paperasse'],";");
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetClientInfoForPdfBD($idEcole,$table,$id){
	$req_sql = "SELECT client.nom,client.prenom,client.adresse, client.adresse_code_postal, adresse_ville From client 
		join ".$table." on link_id_client=id_client
		WHERE client.link_id_ecole=".$idEcole." AND id_".$table."=".$id;
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$ret=Array();
	if($query==true){
		$row = mysqli_fetch_array($query);
		$ret['nom']=$row['nom'];
		$ret['prenom']=$row['prenom'];
		$ret['adresse']=$row['adresse'];
		$ret['adresseCodePostal']=$row['adresse_code_postal'];
		$ret['adresseVille']=$row['adresse_ville'];
	}
	@mysqli_free_result($query);
	return $ret;
}
function GetAllDevisTicketsFacturesBD($idEcole,$annee){
	$req_sql = "SELECT date_creation, link_id_formule, link_id_location, link_id_produit, link_id_facture_groupee, numero, version, total_ht, total_tva, total_ttc, article_taux_tva, article_descriptif, restant_du, invalide_motif, invalide_date, invalide_link_new_id_devis_ticket_facture FROM devis_ticket_facture 
		WHERE devis_ticket_facture.link_id_ecole=".$idEcole." and devis_ticket_facture.date_creation like '".$annee."%' Order by id_devis_ticket_facture";
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$cpt=0;
	$ret=Array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$ret[$cpt]['dateCreation']=$row['date_creation'];
		$ret[$cpt]['idFormule']=$row['link_id_formule'];
		$ret[$cpt]['idLocation']=$row['link_id_location'];
		$ret[$cpt]['idProduit']=$row['link_id_produit'];
		$ret[$cpt]['idFactureGroupee']=$row['link_id_facture_groupee'];
		$ret[$cpt]['numero']=$row['numero'];
		$ret[$cpt]['version']=$row['version'];
		$ret[$cpt]['totalHT']=$row['total_ht'];
		$ret[$cpt]['totalTVA']=$row['total_tva'];
		$ret[$cpt]['totalTTC']=$row['total_ttc'];
		$ret[$cpt]['tauxTVA']=$row['article_taux_tva'];
		$ret[$cpt]['articleDescriptif']=$row['article_descriptif'];
		$ret[$cpt]['restantDu']=$row['restant_du'];
		$ret[$cpt]['invalideMotif']=$row['invalide_motif'];
		$ret[$cpt]['invalideDate']=$row['invalide_date'];
		$ret[$cpt]['invalideLinkNewIdDTF']=$row['invalide_link_new_id_devis_ticket_facture'];
		$ret[$cpt]['invalideLinkNewIdDTFNumero']="";
		$ret[$cpt]['nomClient']="";
		$ret[$cpt]['idClient']=-1;
		$ret[$cpt]['clientType']="client";
		$cpt++;
	}
	@mysqli_free_result($query);

	//appler à requete pour aller chercher les numero_version des invalideLinkNewIdDTF
	$req_sql="SELECT id_devis_ticket_facture,numero, version FROM devis_ticket_facture 
		WHERE devis_ticket_facture.link_id_ecole=".$idEcole;
	$cpt=0;
	foreach($ret as $r){
		if($r['invalideLinkNewIdDTF']!=-1){
			if($cpt==0){
				$req_sql.=" and ( ";
			}
			else{
				$req_sql.=" or ";
			}
			$req_sql.="id_devis_ticket_facture=".$r['invalideLinkNewIdDTF'];
			$cpt++;
		}
	}
	if($cpt>0){
		$req_sql.=" )";
	}
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$tempoNewDTF=array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$tempoNewDTF[$row['id_devis_ticket_facture']]=$row['numero']."_".$row['version'];
	}
	@mysqli_free_result($query);
	//appler à requete pour aller chercher les nom prenom des clients formule
	$req_sql="SELECT id_formule, id_client, client.nom, client.prenom, client.est_groupe_de FROM client 
		JOIN formule on formule.link_id_client=id_client 
		WHERE client.link_id_ecole=".$idEcole;
	$cpt=0;
	foreach($ret as $r){
		if($r['idFormule']!=-1){
			if($cpt==0){
				$req_sql.=" and ( ";
			}
			else{
				$req_sql.=" or ";
			}
			$req_sql.="id_formule=".$r['idFormule'];
			$cpt++;
		}
	}
	if($cpt>0){
		$req_sql.=" )";
	}
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$tempoClientFormule=array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$tempoClientFormule[$row['id_formule']]['nomClient']=$row['prenom']." ".$row['nom'];
		$tempoClientFormule[$row['id_formule']]['idClient']=$row['id_client'];
		$tempoClientFormule[$row['id_formule']]['type']=$row['est_groupe_de']==1?"client":"groupe";
	}
	@mysqli_free_result($query);

	//appler à requete pour aller chercher les nom prenom des clients produit
	$req_sql="SELECT id_produit, id_client, client.nom, client.prenom, client.est_groupe_de FROM client 
		JOIN produit on produit.link_id_client=id_client 
		WHERE client.link_id_ecole=".$idEcole;
	$cpt=0;
	foreach($ret as $r){
		if($r['idProduit']!=-1){
			if($cpt==0){
				$req_sql.=" and ( ";
			}
			else{
				$req_sql.=" or ";
			}
			$req_sql.="id_produit=".$r['idProduit'];
			$cpt++;
		}
	}
	if($cpt>0){
		$req_sql.=" )";
	}
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$tempoClientProduit=array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$tempoClientProduit[$row['id_produit']]['nomClient']=$row['prenom']." ".$row['nom'];
		$tempoClientProduit[$row['id_produit']]['idClient']=$row['id_client'];
		$tempoClientProduit[$row['id_produit']]['type']=$row['est_groupe_de']==1?"client":"groupe";
	}
	@mysqli_free_result($query);

	//appler à requete pour aller chercher les nom prenom des clients location
	$req_sql="SELECT id_location, id_client, client.nom, client.prenom, client.est_groupe_de FROM client 
		JOIN location on location.link_id_client=id_client 
		WHERE client.link_id_ecole=".$idEcole;
	$cpt=0;
	foreach($ret as $r){
		if($r['idLocation']!=-1){
			if($cpt==0){
				$req_sql.=" and ( ";
			}
			else{
				$req_sql.=" or ";
			}
			$req_sql.="id_location=".$r['idLocation'];
			$cpt++;
		}
	}
	if($cpt>0){
		$req_sql.=" )";
	}
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$tempoClientLocation=array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$tempoClientLocation[$row['id_location']]['nomClient']=$row['prenom']." ".$row['nom'];
		$tempoClientLocation[$row['id_location']]['idClient']=$row['id_client'];
		$tempoClientLocation[$row['id_location']]['type']=$row['est_groupe_de']==1?"client":"groupe";
	}
	@mysqli_free_result($query);

	//appler à requete pour aller chercher les nom prenom des clients facture_groupee
	$req_sql="SELECT id_facture_groupee, id_client, client.nom, client.prenom, client.est_groupe_de FROM client 
		JOIN facture_groupee on facture_groupee.link_id_client=id_client 
		WHERE client.link_id_ecole=".$idEcole;
	$cpt=0;
	foreach($ret as $r){
		if($r['idFactureGroupee']!=-1){
			if($cpt==0){
				$req_sql.=" and ( ";
			}
			else{
				$req_sql.=" or ";
			}
			$req_sql.="id_facture_groupee=".$r['idFactureGroupee'];
			$cpt++;
		}
	}
	if($cpt>0){
		$req_sql.=" )";
	}
	$query = mysqli_query($GLOBALS['db'],$req_sql);
	$tempoClientFactureGroupee=array();
	while($query!=false and $row = mysqli_fetch_array($query)){
		$tempoClientFactureGroupee[$row['id_facture_groupee']]['nomClient']=$row['prenom']." ".$row['nom'];
		$tempoClientFactureGroupee[$row['id_facture_groupee']]['idClient']=$row['id_client'];
		$tempoClientFactureGroupee[$row['id_facture_groupee']]['type']=$row['est_groupe_de']==1?"client":"groupe";
	}
	@mysqli_free_result($query);


	//Maintenant on regroupe les infos client, et le num_version du DTF suivant
	$cpt=0;
	foreach($ret as $r){
		if(isset($tempoClientFormule[$r['idFormule']])){
			$ret[$cpt]['nomClient']=$tempoClientFormule[$r['idFormule']]['nomClient'];
			$ret[$cpt]['idClient']=$tempoClientFormule[$r['idFormule']]['idClient'];
			$ret[$cpt]['clientType']=$tempoClientFormule[$r['idFormule']]['type'];
		}
		if(isset($tempoClientProduit[$r['idProduit']])){
			$ret[$cpt]['nomClient']=$tempoClientProduit[$r['idProduit']]['nomClient'];
			$ret[$cpt]['idClient']=$tempoClientProduit[$r['idProduit']]['idClient'];
			$ret[$cpt]['clientType']=$tempoClientProduit[$r['idProduit']]['type'];
		}
		if(isset($tempoClientLocation[$r['idLocation']])){
			$ret[$cpt]['nomClient']=$tempoClientLocation[$r['idLocation']]['nomClient'];
			$ret[$cpt]['idClient']=$tempoClientLocation[$r['idLocation']]['idClient'];
			$ret[$cpt]['clientType']=$tempoClientLocation[$r['idLocation']]['type'];
		}
		if(isset($tempoClientFactureGroupee[$r['idFactureGroupee']])){
			$ret[$cpt]['nomClient']=$tempoClientFactureGroupee[$r['idFactureGroupee']]['nomClient'];
			$ret[$cpt]['idClient']=$tempoClientFactureGroupee[$r['idFactureGroupee']]['idClient'];
			$ret[$cpt]['clientType']=$tempoClientFactureGroupee[$r['idFactureGroupee']]['type'];
		}
		if(isset($tempoNewDTF[$r['invalideLinkNewIdDTF']])){
			$ret[$cpt]['invalideLinkNewIdDTFNumero']=$tempoNewDTF[$r['invalideLinkNewIdDTF']];
		}
		$cpt++;
	}

	return $ret;
}

// hash: 4f035786541b8645c1b8980316a4b8f4feb95d8eabe224a95191fffc6dae189e
?>
